/* ASC2BIN - v 1.1 Detlef Mueller '91 - 
   Usage: ASC2BIN < [input file] > [output file] 
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<io.h>				/* MesS-DOS */
#include	<fcntl.h>			/* MesS-DOS */

#define	MAXDTA	32766				/* MesS-DOS */

static void Error ( int f, char *err )
{
    fprintf( stderr,"\n%s\n", err ) ;

    if ( f )
	exit( -1 ) ;
}

static void PutNibb ( int nibb )
{
    static unsigned char
	in[MAXDTA],			/* Input buffer */
	*p = in ;			/* Pointer to input buffer */
    static unsigned
	crc = 0,			/* CRC value */
	len = 0 ;			/* Count of nibbles in buffer */

    if ( nibb == -1 )			/* Flush input buffer */
    {
	if ( len <= 4 )
	    Error( 1, "Invalid string" ) ;

	if ( crc )
	    Error( 0, "CRC error !!! Be carefull ..." ) ;

	if ( len & 1 )
	    *(p - 2) &= 0x0F ;		/* Mask out 1st CRC nibble */

	printf( "HPHP48-E" ) ;		/* Binary download header */
					/* Flush input buffer to stdout */
	for ( p = in, nibb = (len - 3) >> 1 ; nibb ; --nibb, ++p )
	    putc( *p, stdout ) ;

	return ;
    }

    if ( ++len & 1 )
	*p = nibb ;
    else
	*p++ |= nibb << 4 ;

    if ( len > MAXDTA )			/* Input to big .. */
	Error( 1, "File to big ..." ) ;

    nibb = (crc ^ nibb) & 0x0F ;	/* Update CRC value */
    crc  = (crc >> 4) ^ (nibb | (nibb << 7) | (nibb << 12)) ;
}

void main ( void )
{
    int
	i ;

    setmode( fileno( stdout ), O_BINARY ) ;	/* MesS-DOS */

    while ( (i = getc( stdin )) != '"' ) /* Search for start of str */
	if ( i == EOF )
	    Error( 1, "No data found" ) ;

    while ( (i = getc( stdin )) != '"' )
	if ( isxdigit( i ) )		/* Is hex-digit */
	    PutNibb( i - (i > '9' ? '7' : '0') ) ;
	else
	if ( i == EOF )
	    Error( 1, "Unexpected EOF" ) ;

    PutNibb( -1 ) ;			/* Flush input buffer */

    exit( 0 ) ;
}
